/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Table;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.AbstractStoreView;
import cz.insophy.inplan.store.InPlanMatReqStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.PairingQueue;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public abstract class PairingStoreView
extends AbstractStoreView {
    protected final StoreSchedule overridingSchedule;
    protected final StoreSchedule targetSchedule;
    private final Table<Material, StoreActivity, Double> overridingPairing;
    private final Table<Material, StoreActivity, Double> targetPairing;

    public PairingStoreView(StoreSchedule targetSchedule, StoreSchedule overridingSchedule) {
        super(overridingSchedule.getMaterials(), Arrays.asList(overridingSchedule, targetSchedule));
        if (!overridingSchedule.getMaterials().equals(targetSchedule.getMaterials())) {
            throw new IllegalArgumentException("Transaction and Plantune schedules must have the same material sets.");
        }
        this.overridingSchedule = overridingSchedule;
        this.targetSchedule = targetSchedule;
        this.overridingPairing = HashBasedTable.create();
        this.targetPairing = HashBasedTable.create();
    }

    @Override
    protected void createCache(Material m3) {
        PairingQueue queue;
        this.overridingPairing.rowKeySet().remove(m3);
        this.targetPairing.rowKeySet().remove(m3);
        CachedSasBuilder cacheBuilder = new CachedSasBuilder((List)this.activities.get(m3), this.overridingSchedule.getActivities(m3));
        IdentityHashMap<Object, PairingQueue> queues = Maps.newIdentityHashMap();
        for (StoreActivity sa : this.overridingSchedule.getActivities(m3)) {
            Object pairingKey = this.getPairingKeyFromOverriding(sa);
            queue = (PairingQueue)queues.get(pairingKey);
            if (queue == null) {
                queue = new PairingQueue(this.overridingPairing, this.targetPairing);
                queues.put(pairingKey, queue);
            }
            queue.addOverriding(sa);
        }
        for (StoreActivity sa : this.targetSchedule.getActivities(m3)) {
            Object relatedTarget = this.getPairingKeyFromTarget(sa);
            queue = (PairingQueue)queues.get(relatedTarget);
            if (relatedTarget == null || queue == null || !queue.hasSomethingFor(sa.getQty())) {
                cacheBuilder.addTargetSa((StoreActivity)sa.duplicate());
                this.targetPairing.put(m3, sa, 0.0);
                continue;
            }
            double newSaQty = queue.pairTarget(sa);
            if (newSaQty == 0.0) continue;
            cacheBuilder.addTargetSa(new InPlanMatReqStoreActivity(sa.getStoreType(), sa.getTime(), sa.getMaterial(), newSaQty, ((InPlanStoreActivity)sa).getOwner()));
        }
        for (PairingQueue queue2 : queues.values()) {
            queue2.flush();
        }
        cacheBuilder.flush();
    }

    public List<StoreActivity> getTargetPairingSortedKeys(Material m3) {
        this.updateCache(m3);
        return PairingStoreView.getPairingSortedKeys(this.targetPairing, m3);
    }

    public List<StoreActivity> getOverridingPairingSortedKeys(Material m3) {
        this.updateCache(m3);
        return PairingStoreView.getPairingSortedKeys(this.overridingPairing, m3);
    }

    public Double getTargetPairing(StoreActivity sa) {
        this.updateCache(sa.getMaterial());
        return this.targetPairing.get(sa.getMaterial(), sa);
    }

    public Double getOverridingPairing(StoreActivity sa) {
        this.updateCache(sa.getMaterial());
        return this.overridingPairing.get(sa.getMaterial(), sa);
    }

    private static List<StoreActivity> getPairingSortedKeys(Table<Material, StoreActivity, Double> pairingTable, Material m3) {
        Set<StoreActivity> saSet = pairingTable.row(m3).keySet();
        ArrayList<StoreActivity> saList = Lists.newArrayListWithCapacity(saSet.size());
        saList.addAll(saSet);
        Collections.sort(saList);
        return saList;
    }

    public StoreSchedule getOverridingSchedule() {
        return this.overridingSchedule;
    }

    public StoreSchedule getTargetSchedule() {
        return this.targetSchedule;
    }

    protected abstract Object getPairingKeyFromOverriding(StoreActivity var1);

    protected abstract Object getPairingKeyFromTarget(StoreActivity var1);

    private static final class CachedSasBuilder {
        private final List<StoreActivity> cachedSas;
        private final PeekingIterator<StoreActivity> ovrSasIter;

        public CachedSasBuilder(List<StoreActivity> cachedSas, List<StoreActivity> overridingSas) {
            this.cachedSas = cachedSas;
            this.ovrSasIter = Iterators.peekingIterator(overridingSas.iterator());
            cachedSas.clear();
        }

        public void addTargetSa(StoreActivity sa) {
            while (this.ovrSasIter.hasNext() && this.ovrSasIter.peek().getTime() <= sa.getTime()) {
                this.cachedSas.add((StoreActivity)this.ovrSasIter.next().duplicate());
            }
            this.cachedSas.add(sa);
        }

        public void flush() {
            while (this.ovrSasIter.hasNext()) {
                this.cachedSas.add((StoreActivity)this.ovrSasIter.next().duplicate());
            }
        }
    }
}

